// Autor: Ivan Katanic

#include <algorithm>
#include <cassert>
#include <cstring>
#include <iostream>

using namespace std;

const int MAXN = 1010;
const int inf = 1e9;

enum Tip {NULA, JEDAN, AND, OR, XOR};

vector<int> E[MAXN];
Tip tip[MAXN];
int price[MAXN];
char s[MAXN];
int sprice[MAXN];
int pos;

int parse() {
  int x = pos;
  if (isdigit(s[pos])) {
    tip[x] = s[pos] == '0' ? NULA : JEDAN;
    price[x] = sprice[pos];
    pos++;
    return x;
  }

  assert(s[pos] == '(');
  pos++;
  
  while (s[pos] != ')') {
    E[x].push_back(parse());

    if (s[pos] != ')') {
      if (s[pos] == '&') tip[x] = AND; else
        if (s[pos] == '|') tip[x] = OR; else
          if (s[pos] == '^') tip[x] = XOR; else
            assert(false);

      pos++;
    }
  }
  pos++;
  assert((int)E[x].size() > 1);
  return x;
}

int f[MAXN][2];
int nf[2];

int calc(bool a, Tip oper, bool b) {
  if (oper == AND) return a & b; else
    if (oper == OR) return a | b; else
      if (oper == XOR) return a ^ b; else
        assert(false);
}

void solve(int x) {
  for (int y: E[x]) solve(y);
  
  if (tip[x] == NULA) {
    f[x][0] = 0, f[x][1] = price[x];
    return;
  }
  if (tip[x] == JEDAN) {
    f[x][0] = price[x], f[x][1] = 0;
    return;
  }

  if (tip[x] == AND) {
    f[x][1] = 0, f[x][0] = inf;
  } else {
    f[x][0] = 0, f[x][1] = inf;
  }

  for (int y: E[x]) {
    nf[0] = nf[1] = inf;
    for (int xv = 0; xv < 2; ++xv)
      for (int yv = 0; yv < 2; ++yv) {
        int rez = calc(xv, tip[x], yv);
        nf[rez] = min(nf[rez], f[x][xv] + f[y][yv]);
      }
    f[x][0] = nf[0], f[x][1] = nf[1];
  }
}

int main(void) {
  scanf("%s", s);
  int n = strlen(s);
  for (int i = 0; i < n; ++i)
    if (isdigit(s[i])) scanf("%d", sprice+i);

  pos = 0;
  int x = parse();
  solve(x);
  printf("%d\n", f[x][1]);
  return 0;
}
